
<div class="dynamic-input-wrapper"
     data-input-name="<?php echo e($name); ?>"
     data-placeholder="<?php echo e($placeholder); ?>"
     data-input-type="<?php echo e($inputType); ?>"
     data-column-class="<?php echo e($columnClass); ?>"
     data-required="<?php echo e($required); ?>">
    <div class="mb-4">
        <div class="justify-content-between">
            <div class="form-group">
                <a href="javascript:void(0)" class="btn btn-success float-left mt-3 add-item">
                    <i class="fa fa-<?php echo e($icon); ?>"></i> <?php echo e($buttonText); ?>

                </a>
            </div>
            <div class="row items-container mt-3 col-md-10">
                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="<?php echo e($columnClass); ?> pb-2 dynamic-input-group">
                        <div class="form-group">
                            <div class="input-group">
                                <input name="<?php echo e($name); ?>[]"
                                       class="form-control"
                                       type="<?php echo e($inputType); ?>"
                                       value="<?php echo e($item); ?>"
                                       <?php echo e($required ? 'required' : ''); ?>

                                       placeholder="<?php echo e($placeholder); ?>">
                                <span class="input-group-btn">
                                    <button class="btn btn-white delete-item" type="button">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </span>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</div>

<?php if (! $__env->hasRenderedOnce('1157a6bf-f8c0-44bf-9354-2892a87663e5')): $__env->markAsRenderedOnce('1157a6bf-f8c0-44bf-9354-2892a87663e5'); ?>
    <?php $__env->startPush('script'); ?>
    <script>
    $(document).ready(function() {
        function initDynamicInput(wrapper) {
            const $wrapper = $(wrapper);
            const inputName = $wrapper.data('input-name');
            const placeholder = $wrapper.data('placeholder');
            const inputType = $wrapper.data('input-type');
            const columnClass = $wrapper.data('column-class');
            const required = $wrapper.data('required');

            // Add new item
            $wrapper.find('.add-item').click(function() {
                const newInput = `
                    <div class="${columnClass} pb-2 dynamic-input-group">
                        <div class="form-group">
                            <div class="input-group">
                                <input name="${inputName}[]"
                                       class="form-control"
                                       type="${inputType}"
                                       ${required ? 'required' : ''}
                                       placeholder="${placeholder}">
                                <span class="input-group-btn">
                                    <button class="btn btn-white delete-item" type="button">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </span>
                            </div>
                        </div>
                    </div>
                `;
                $wrapper.find('.items-container').append(newInput);
            });

            // Delete item
            $wrapper.on('click', '.delete-item', function() {
                $(this).closest('.dynamic-input-group').remove();
            });
        }

        // Initialize all dynamic input components on the page
        $('.dynamic-input-wrapper').each(function() {
            initDynamicInput(this);
        });
    });
    </script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>
<?php /**PATH C:\Users\JIASAN\Herd\bdtravel\resources\views/components/dynamic-input.blade.php ENDPATH**/ ?>